define(['app', 'angular'], function(app) {

	app.directive('inputSelect', function() {
		return {
			restrict: 'E',
			require: 'ngModel',
			scope: {
				'label': '@',
				'name': '@',
				'nullLabel': '@',
				'hideNullOption': '=',
				'options': '=',
				'ngDisabled': '=',
				'ngRequired': '=',
				'requiredMsg': '@',
				'ngModel': '=',
				'itemChangeCallback': '&',
				'index': '@',
				'id': '@'
			},
			link: function(scope, element, attrs, ngModelCtrl) {
				var label = scope.label.lastIndexOf(":") === scope.label.length - 1 ? scope.label.substr(0, scope.label.length - 1) : scope.label;
				scope.errorHandling = {
					'required': {
						message: scope.requiredMsg ? scope.requiredMsg : label + ' field is required.',
						priority: 1
					}
				};
				if (scope.index) {
					scope.change = function(model) {
						scope.itemChangeCallback()(model.newValue, scope.index);
					}
				}
			},
			templateUrl: function(elem, attr) {
				return attr.useObjectOptions ? 'src/ui-components/form/controls/simple/input-select/input-select-object_template.html' : 'src/ui-components/form/controls/simple/input-select/input-select_template.html';
			}
		};
	});
});
